IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'P_EST_PROD_CPL_REPLIC_EMAX_ESEG') AND type in (N'P', N'PC'))
begin
	DROP PROCEDURE P_EST_PROD_CPL_REPLIC_EMAX_ESEG
end
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20221101
'Job.................:  
'Nome................:  P_EST_PROD_CPL_REPLIC_EMAX_ESEG
'Objetivo............: 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2022-11-01
'Alterado por........: Jerfeson Barbosa
'Criado por..........: 
'=======================================================================================
FARMAGOI-34334 -  
 */


-- EXEC P_EST_PROD_CPL_REPLIC_EMAX_ESEG 1, 1 
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_REPLIC_EMAX_ESEG] @CD_EMP_PAR INT=1, @CD_FILIAL_PAR INT=0, @CD_PROD_PAR INT=0 AS
SET DEADLOCK_PRIORITY HIGH;
SET NOCOUNT ON
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @DT_REF AS DATE
SET @DT_REF =  GETDATE()  ;
SET @CD_EMP = 0
SET @CD_FILIAL =0
DECLARE @FLAG_NOVO_MODELO_PARAMETROS INT;
BEGIN  TRY
DECLARE cFilial CURSOR FAST_FORWARD FOR 
	SELECT  
		f.CD_EMP, 
		f.CD_FILIAL
	FROM 
		PRC_FILIAL F  
	WHERE	
		f.CD_EMP=@CD_EMP_PAR
		AND f.CD_FILIAL = CASE WHEN @CD_FILIAL_PAR > 0 THEN @CD_FILIAL_PAR ELSE f.CD_FILIAL END
		AND STS_FILIAL=0
	ORDER BY f.CD_FILIAL	 
	OPEN cFilial
	FETCH NEXT FROM cFilial INTO @CD_EMP, @CD_FILIAL
	PRINT 'Abriu o cursor registros para atualizacao ' +  (CONVERT(VARCHAR(8), GETDATE(),108));
WHILE @@FETCH_STATUS=0
	Begin
		TRUNCATE TABLE EST_PROD_CPL_REPLIC_EMAX_ESEG;
		TRUNCATE TABLE EST_PROD_CPL_REPLIC_EMAX_ESEG_AUX
/*********************************************************************************************************************************************************************/
		SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL(
											(
												SELECT VALOR FROM PRC_EMP_CONFIG
												WHERE  CD_EMP = @CD_EMP_PAR
														AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'
											), 0);
		if @FLAG_NOVO_MODELO_PARAMETROS =0
		begin
			SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL(
											(
												SELECT VALOR FROM PRC_FILIAL_CONFIG
												WHERE  CD_EMP = @CD_EMP_PAR
														AND CD_FILIAL =@CD_FILIAL
														AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'
											), 0);
		end
/*********************************************************************************************************************************************************************/
IF @FLAG_NOVO_MODELO_PARAMETROS=0 --Modelo antigo
BEGIN
	PRINT 'PARAMETRO ANTIGO'
		INSERT INTO EST_PROD_CPL_REPLIC_EMAX_ESEG
		SELECT
			C.CD_EMP,
			C.CD_FILIAL,
			C.CD_PROD,
			0 AS EMAX, 
			0 AS ESEG, 
			M.QTDE_FINANCIADO AS QTDE_FINANCIADO,
			M.QTDE_LIMITADOR  AS QTDE_LIMITADOR,
			M.QTDE_FACEAMENTO AS  QTDE_FACEAMENTO,
			M.QTDE_MEDIAF AS MEDIAF,
			M.QT_VD_MES1 AS QT_VD_MES1,
			M.QT_VD_MES2 AS QT_VD_MES2,
			M.QT_VD_MES3 AS QT_VD_MES3,
			NASC.QTDE_MES_VENDA_FECHADO AS QTDE_MES_VENDA_FECHADO,
			0 VLR_CUSTO_GER,
			0 VLR_CUSTO_MD,
			M.PERC_ESEG_FACEAMENTO,
			M.CD_SIGLA CD_SIGLA,
			M.FLAG_FACE_COMPLEMENTAR,
			0 VLR_CUSTO
		FROM
			EST_PROD_CPL C 
			LEFT JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA A ON 
			C.CD_EMP	= A.CD_EMP    AND 
			C.CD_FILIAL = A.CD_FILIAL AND 
			C.CD_PROD	= A.CD_PROD
			INNER JOIN EST_PROD_CPL_MEDIAF M ON
			C.CD_EMP	= M.CD_EMP	   AND
			C.CD_FILIAL = M.CD_FILIAL  AND
			C.CD_PROD	= M.CD_PROD
			LEFT JOIN EST_PROD_CPL_NASC NASC ON 
			C.CD_EMP	= NASC.CD_EMP    AND 
			C.CD_FILIAL = NASC.CD_FILIAL AND 
			C.CD_PROD	= NASC.CD_PROD 
		WHERE
			C.CD_EMP	= @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL
			AND C.CD_PROD = CASE WHEN @CD_PROD_PAR=0 THEN C.CD_PROD ELSE @CD_PROD_PAR END ;
		update c
		set
			MEDIAF =p.qtde_mediap
		from  
			EST_PROD_CPL_REPLIC_EMAX_ESEG C
			INNER JOIN EST_PROD_CPL_MEDIAP p ON
			C.CD_EMP	= P.CD_EMP	   AND
			C.CD_FILIAL = P.CD_FILIAL  AND
			C.CD_PROD	= P.CD_PROD
		where
			mediaf=0
			and p.qtde_mediap> 0
			and p.CD_EMP	= @CD_EMP
			AND p.CD_FILIAL = @CD_FILIAL
		update c
		set
			EMAX =A.EMAX,
			ESEG =A.ESEG
		from  
			EST_PROD_CPL_REPLIC_EMAX_ESEG C
		    JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA A ON 
			C.CD_EMP	= A.CD_EMP    AND 
			C.CD_FILIAL = A.CD_FILIAL AND 
			C.CD_PROD	= A.CD_PROD
		where
			A.CD_EMP	= @CD_EMP
			AND A.CD_FILIAL = @CD_FILIAL
end
IF @FLAG_NOVO_MODELO_PARAMETROS=1 --Modelo NOVO
BEGIN
		PRINT 'PARAMETRO NOVO'
		INSERT INTO EST_PROD_CPL_REPLIC_EMAX_ESEG
		SELECT
			C.CD_EMP,
			C.CD_FILIAL,
			C.CD_PROD,
			EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.EMAX, 
			EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.ESEG,
			M.QTDE_FINANCIADO AS QTDE_FINANCIADO,
			M.QTDE_LIMITADOR  AS QTDE_LIMITADOR,
			M.QTDE_FACEAMENTO AS  QTDE_FACEAMENTO,
			M.QTDE_MEDIA AS MEDIAF,
			M.QT_VD_MES1 AS QT_VD_MES1,
			M.QT_VD_MES2 AS QT_VD_MES2,
			M.QT_VD_MES3 AS QT_VD_MES3,
			NASC.QTDE_MES_VENDA_FECHADO AS QTDE_MES_VENDA_FECHADO,
			0 VLR_CUSTO_GER,
			0 VLR_CUSTO_MD,
			M.PERC_ESEG_FACEAMENTO,
			M.CD_SIGLA CD_SIGLA,
			M.FLAG_FACE_COMPLEMENTAR,
			0 VLR_CUSTO
		FROM
			EST_PROD_CPL C 
			INNER JOIN V_EST_PROD_CPL_MEDIAF_MEDIAP M ON
			C.CD_EMP	= M.CD_EMP	   AND
			C.CD_FILIAL = M.CD_FILIAL  AND
			C.CD_PROD	= M.CD_PROD
			LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD A ON
			C.CD_EMP	= A.CD_EMP    AND 
			C.CD_FILIAL = A.CD_FILIAL AND 
			C.CD_PROD	= A.CD_PROD AND
			M.CD_SIGLA = A.CD_SIGLA
			LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_CURVA on 
			A.CD_GRUPO_CURVA= EST_PARAM_COMPRAS_GRUPO_CURVA.CD_GRUPO_CURVA 
			LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA on
			A.cd_grupo_curva = EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.CD_GRUPO_CURVA and
			M.CD_SIGLA = EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.CD_SIGLA
			LEFT JOIN EST_PROD_CPL_NASC NASC ON 
			C.CD_EMP	= NASC.CD_EMP    AND 
			C.CD_FILIAL = NASC.CD_FILIAL AND 
			C.CD_PROD	= NASC.CD_PROD 
		WHERE
			C.CD_EMP	= @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL  
			AND C.CD_PROD = CASE WHEN @CD_PROD_PAR=0 THEN C.CD_PROD ELSE @CD_PROD_PAR END 
end
		PRINT 'Selecionou  registros para atualizacao ' +  (CONVERT(VARCHAR(8), GETDATE(),108));	
/*********************************************************************************************************************************************************************/
/*********************************************************************************************************************************************************************/
		UPDATE T
		SET	
			VLR_CUSTO_GER = A.VLR_CUSTO_GER_NOVO , 
			VLR_CUSTO_MD  = A.VLR_CUSTO_MD_NOVO 
		FROM 
			EST_FECHA_PROC_MOV A
			JOIN (SELECT 
					A.CD_EMP,
					A.CD_FILIAL,
					A.CD_PROD,
					MAX(B.DT_PROC) DT_PROC
				FROM 
					EST_PROD_CPL_REPLIC_EMAX_ESEG A
					JOIN EST_FECHA_PROC_MOV B ON 
					A.CD_EMP	= B.CD_EMP AND
					A.CD_FILIAL = B.CD_FILIAL AND
					A.CD_PROD	= B.CD_PROD
				WHERE
					B.CD_EMP=@CD_EMP
					AND B.CD_FILIAL =@CD_FILIAL
				GROUP BY 
					A.CD_EMP,
					A.CD_FILIAL,
					A.CD_PROD) B ON 
			A.CD_EMP	= B.CD_EMP AND
			A.CD_FILIAL = B.CD_FILIAL AND
			A.DT_PROC   = B.DT_PROC AND
			A.CD_PROD	= B.CD_PROD   
			JOIN EST_PROD_CPL_REPLIC_EMAX_ESEG T ON 
			A.CD_EMP	= T.CD_EMP AND
			A.CD_FILIAL = T.CD_FILIAL AND
			A.CD_PROD	= T.CD_PROD
PRINT 'Selecionou  registros para atualizacao VLR_CUSTO ' +  (CONVERT(VARCHAR(8), GETDATE(),108));
		UPDATE T
		SET	
			VLR_CUSTO 	  = A.VLR_ENT 
		FROM 
			EST_FECHA_PROC_MOV A
			JOIN (SELECT 
					A.CD_EMP,
					A.CD_FILIAL,
					A.CD_PROD,
					MAX(B.DT_PROC) DT_PROC
				FROM 
					EST_PROD_CPL_REPLIC_EMAX_ESEG A
					JOIN EST_FECHA_PROC_MOV B ON 
					A.CD_EMP	= B.CD_EMP AND
					A.CD_FILIAL = B.CD_FILIAL AND
					A.CD_PROD	= B.CD_PROD
				WHERE
					B.CD_EMP=@CD_EMP
					AND B.CD_FILIAL =@CD_FILIAL
					AND B.VLR_ENT > 0 
				GROUP BY 
					A.CD_EMP,
					A.CD_FILIAL,
					A.CD_PROD) B ON 
			A.CD_EMP	= B.CD_EMP AND
			A.CD_FILIAL = B.CD_FILIAL AND
			A.DT_PROC   = B.DT_PROC AND
			A.CD_PROD	= B.CD_PROD   
			JOIN EST_PROD_CPL_REPLIC_EMAX_ESEG T ON 
			A.CD_EMP	= T.CD_EMP AND
			A.CD_FILIAL = T.CD_FILIAL AND
			A.CD_PROD	= T.CD_PROD
		PRINT 'atualizaou custo dos registros ' +  (CONVERT(VARCHAR(8), GETDATE(),108));	
		UPDATE a
		  SET
			  EMAX = isnull(EMAX, 0)
			, ESEG = isnull(ESEG, 0)
			, QTDE_FINANCIADO = isnull(QTDE_FINANCIADO, 0)
			, QTDE_LIMITADOR = isnull(QTDE_LIMITADOR, 0)
			, QTDE_FACEAMENTO = isnull(QTDE_FACEAMENTO, 0)
			, MEDIAF = isnull(MEDIAF, 0)
			, QT_VD_MES1 = isnull(QT_VD_MES1, 0)
			, QT_VD_MES2 = isnull(QT_VD_MES2, 0)
			, QT_VD_MES3 = isnull(QT_VD_MES3, 0)
			, QTDE_MES_VENDA_FECHADO = isnull(QTDE_MES_VENDA_FECHADO, 0)
			, VLR_CUSTO_GER = isnull(VLR_CUSTO_GER, 0)
			, VLR_CUSTO_MD = isnull(VLR_CUSTO_MD, 0)
			, PERC_ESEG_FACEAMENTO = isnull(PERC_ESEG_FACEAMENTO, 0)
			, CD_SIGLA = isnull(CD_SIGLA, 4)
			, FLAG_FACE_COMPLEMENTAR = isnull(FLAG_FACE_COMPLEMENTAR, 0)
			, VLR_CUSTO = isnull(VLR_CUSTO,0)
		FROM   EST_PROD_CPL_REPLIC_EMAX_ESEG a;
		INSERT INTO EST_PROD_CPL_REPLIC_EMAX_ESEG_AUX
		SELECT 
			T.CD_EMP,
			T.CD_FILIAL,
			T.CD_PROD
		FROM  
			EST_PROD_CPL C
			INNER JOIN EST_PROD_CPL_REPLIC_EMAX_ESEG T ON C.CD_EMP = T.CD_EMP
									  AND C.CD_PROD = T.CD_PROD
									  AND C.CD_FILIAL = T.CD_FILIAL
		WHERE
		  C.CD_EMP = @CD_EMP
		  AND C.CD_FILIAL = @CD_FILIAL
		  AND (C.EMAX <> T.EMAX
			   OR C.ESEG <> T.ESEg
			   OR C.QTDE_FINANCIADO <> T.QTDE_FINANCIADO
			   OR C.QTDE_LIMITADOR <> T.QTDE_LIMITADOR
			   OR C.QTDE_FACEAMENTO <> T.QTDE_FACEAMENTO
			   OR C.MEDIAF <> T.MEDIAF
			   OR C.QT_VD_MES1 <> T.QT_VD_MES1
			   OR C.QT_VD_MES2 <> T.QT_VD_MES2
			   OR C.QT_VD_MES3 <> T.QT_VD_MES3
			   OR C.QTDE_MES_VENDA_FECHADO <> T.QTDE_MES_VENDA_FECHADO
			   OR C.VLR_CUSTO_GER  <> T.VLR_CUSTO_GER					
			   OR C.VLR_CUSTO_MD <>  T.VLR_CUSTO_MD 
			   OR C.PERC_ESEG_FACEAMENTO <> T.PERC_ESEG_FACEAMENTO
			   OR c.CD_SIGLA <> T.CD_SIGLA
			   OR C.VLR_CUSTO <> T.VLR_CUSTO);	
		DELETE FROM A
			FROM 
				EST_PROD_CPL_REPLIC_EMAX_ESEG A
				LEFT JOIN EST_PROD_CPL_REPLIC_EMAX_ESEG_AUX B ON 
				A.CD_EMP	= B.CD_EMP AND
				A.CD_PROD	= B.CD_PROD AND
				A.CD_FILIAL = B.CD_FILIAL
			WHERE 
			B.CD_EMP IS NULL
			AND A.CD_EMP = @CD_EMP
			AND	A.CD_FILIAL = @CD_FILIAL;
		PRINT 'Preparou a tabela de atualizacao  ' +  (CONVERT(VARCHAR(8), GETDATE(),108));	
/*********************************************************************************************************************************************************************/
		UPDATE C
		  SET
			  EMAX = T.EMAX
			, ESEG = T.ESEG
			, QTDE_FINANCIADO = T.QTDE_FINANCIADO
			, QTDE_LIMITADOR = T.QTDE_LIMITADOR
			, QTDE_FACEAMENTO = T.QTDE_FACEAMENTO
			, MEDIAF = T.MEDIAF
			, QT_VD_MES1 = T.QT_VD_MES1
			, QT_VD_MES2 = T.QT_VD_MES2
			, QT_VD_MES3 = T.QT_VD_MES3
			, C.QTDE_MES_VENDA_FECHADO = T.QTDE_MES_VENDA_FECHADO
			, C.DT_ATUALIZA_PARAM = GETDATE()
			, C.PERC_ESEG_FACEAMENTO = T.PERC_ESEG_FACEAMENTO
			, c.CD_SIGLA = T.CD_SIGLA
			, C.FLAG_FACE_COMPLEMENTAR = T.FLAG_FACE_COMPLEMENTAR
			, C.VLR_CUSTO_GER = T.VLR_CUSTO_GER
			, C.VLR_CUSTO_MD = T.VLR_CUSTO_MD
			, C.VLR_CUSTO    = CASE WHEN T.VLR_CUSTO =0 THEN  T.VLR_CUSTO_MD ELSE T.VLR_CUSTO END
		FROM   EST_PROD_CPL C
			   INNER JOIN EST_PROD_CPL_REPLIC_EMAX_ESEG T ON C.CD_EMP = T.CD_EMP
										  AND C.CD_PROD = T.CD_PROD
										  AND C.CD_FILIAL = T.CD_FILIAL
		WHERE
			  C.CD_EMP = @CD_EMP
			  AND C.CD_FILIAL = @CD_FILIAL ;			
		PRINT 'Atualizou a filial ' + CONVERT(VARCHAR(5),@CD_FILIAL) + ' - '  +  (CONVERT(VARCHAR(8), GETDATE(),108));
		--Proximo registro
		FETCH NEXT FROM cFilial INTO @CD_EMP, @CD_FILIAL 
	End
CLOSE cFilial;
DEALLOCATE cFilial;
/******************************************************************************************************************************************************/
	PRINT 'Atualiza preco de custo grupo ' + (CONVERT(VARCHAR(8), GETDATE(),108));
/******************************************************************************************************************************************************/
	CREATE TABLE #TMP_VLR_CUSTO_GRP( CD_EMP INT, CD_PROD INT, VLR_CUSTO_GRP  MONEY)
	INSERT INTO #TMP_VLR_CUSTO_GRP
		SELECT
			   EST_NF_ENT_IT.CD_EMP
			 , EST_NF_ENT_IT.CD_PROD
			 , MAX(EST_NF_ENT_IT.VLR_PRC_CUSTO) VLR_PRC_CUSTO
		FROM
			 EST_NF_ENT
			 INNER JOIN EST_NF_ENT_IT ON EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP
										 AND EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL
										 AND EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF
			 INNER JOIN
			 EST_PROD_ENT_GRP_ECON
			 INNER JOIN EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT ON EST_PROD_ENT_GRP_ECON.CD_EMP = EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT.CD_EMP
															   AND EST_PROD_ENT_GRP_ECON.CD_PROD = EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT.CD_PROD ON EST_NF_ENT_IT.CD_EMP = EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT.CD_EMP
																																				  AND EST_NF_ENT_IT.CD_FILIAL = EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT.CD_FILIAL
																																				  AND EST_NF_ENT_IT.CD_NF = EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT.CD_NF
																																				  AND EST_NF_ENT_IT.CD_PROD = EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT.CD_PROD
		WHERE EST_PROD_ENT_GRP_ECON.CD_EMP = 1
		GROUP BY
				 EST_NF_ENT_IT.CD_PROD,  EST_NF_ENT_IT.CD_EMP
	------------------------------------------------------------------------------------------------------------
	DELETE FROM I
	FROM
		#TMP_VLR_CUSTO_GRP I
		INNER JOIN EST_PROD P ON P.CD_EMP = I.CD_EMP
							 AND P.CD_PROD = I.CD_PROD 
	WHERE
		I.VLR_CUSTO_GRP = P.VLR_CUSTO_GRP;
	------------------------------------------------------------------------------------------------------------
	UPDATE P
	SET
		VLR_CUSTO_GRP = I.VLR_CUSTO_GRP
	FROM
	#TMP_VLR_CUSTO_GRP I
	INNER JOIN EST_PROD P ON P.CD_EMP = I.CD_EMP
							 AND P.CD_PROD = I.CD_PROD;

DROP TABLE #TMP_VLR_CUSTO_GRP
/******************************************************************************************************************************************************/
END TRY
BEGIN CATCH
    DECLARE @ErrorMessage VARCHAR(4000)=ERROR_MESSAGE();  
	   DECLARE @ErrorSeverity INT=ERROR_SEVERITY();  
	   DECLARE @ErrorState INT=ERROR_STATE();  
	   INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro )
        SELECT ERROR_NUMBER() AS numero,
                @ErrorSeverity AS severidade,
                @ErrorState AS estado,
                ERROR_PROCEDURE() AS rotina,
                ERROR_LINE() AS linha,
                @ErrorMessage AS mensagem,
                GETDATE() AS dtErro;
	   RAISERROR (@ErrorMessage, 
			    @ErrorSeverity,
			    @ErrorState );
END CATCH
GO


